using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static int[] Zec(int n, List<int>[] graf, int[] platforme, int[] izlazi,int[] izmene)
    {
        int[] potrebniskokovi = new int[n + 1];
        for (int i = 0; i <= n; i++)
        {
            potrebniskokovi[i] = -1;
        }

        foreach (int izlaz in izlazi)
        {
            Queue<int> red = new Queue<int>();
            HashSet<int> posecen = new HashSet<int>();
            red.Enqueue(izlaz);
            posecen.Add(izlaz);
            potrebniskokovi[izlaz] = 0;

            while (red.Count > 0)
            {
                int trenutnasoba = red.Dequeue();

                foreach (int sused in graf[trenutnasoba])
                {
                    if (!posecen.Contains(sused))
                    {
                        posecen.Add(sused);

                        if (platforme[sused - 1] == 1 || izmene[sused - 1] == 1)
                        {
                            potrebniskokovi[sused] = potrebniskokovi[trenutnasoba] + 1;
                            red.Enqueue(sused);
                        }
                        else
                        {
                            if (potrebniskokovi[sused] == -1)
                            {
                                potrebniskokovi[sused] = potrebniskokovi[trenutnasoba] + 1;
                                red.Enqueue(sused);
                            }
                        }
                    }
                }
            }
        }

        return potrebniskokovi;
    }
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        List<int>[] graf = new List<int>[n + 1];
        for (int i = 1; i <= n; i++)
        {
            graf[i] = new List<int>();
        }

        for (int i = 0; i < n - 1; i++)
        {
            string[] ulaz = Console.ReadLine().Split();
            int Ui = int.Parse(ulaz[0]);
            int Vi = int.Parse(ulaz[1]);
            graf[Ui].Add(Vi);
            graf[Vi].Add(Ui);
        }

        int[] platforme = Console.ReadLine().Split().Select(int.Parse).ToArray();
        int[] izmene = Console.ReadLine().Split().Select(int.Parse).ToArray();

        int[] izlazi = Enumerable.Range(1, n).Where(i => graf[i].Count == 1 || i == 1).ToArray();
        int[] potrebniskokovi = Zec(n, graf, platforme,  izlazi,izmene);

        for (int i = 1; i <= n; i++)
        {
            Console.Write(potrebniskokovi[i] + " ");
        }
    }
}